<?php

namespace UtillzCore\Inc\Src\Listing\Modules\Author;

use \UtillzCore\Inc\Src\Listing\Modules\Module;
use \UtillzCore\Inc\Src\User;

class Author extends Module {

    public function controller() {

        global $ulz_listing;
        $user_id = $ulz_listing->post->post_author;

        $userdata = get_userdata( $user_id );
        $user = new User( $user_id );

        return array_merge( (array) $this->props, [
            'listing' => $ulz_listing,
            'user' => $user,
            'userdata' => $userdata,
            'user_description' => get_the_author_meta( 'description', $user_id ),
            'user_public_url' => get_author_posts_url( $user_id ),
            'join_date' => date( get_option('date_format'), strtotime( $userdata->user_registered ) ),
            'total_reviews' => $user->get_total_reviews(),
            'strings' => (object) [
                'verified' => esc_html__('Verified', 'utillz-core'),
                'review' => esc_html__('%s review', 'utillz-core'),
                'reviews' => esc_html__('%s reviews', 'utillz-core'),
                'contact' => esc_html__('Contact %s', 'utillz-core'),
                'public_profile' => esc_html__('View profile', 'utillz-core'),
            ]
        ]);

    }

}
